;+
; NAME:
;    ipccar6dna_conf_physics.pro
;
; PURPOSE:
;    This function determines a degradation factor for the confidence metric 
;    used in the IPCC AR6 WGII detection and attribution assessments, based on 
;    basic physical understanding of the climate variable.
;
; CATEGORY:
;    IPCC AR6 WGII DA
;
; CALLING SEQUENCE:
;    result = ipccar6dna_conf_physics( var_label )
;
; INPUT:
;    VAR_LABEL:  A required string scalar specifying the CMOR label of the 
;        climate variable, e.g. 'tas' for near-surface air temperature, and 
;        'pr' for precipitation.
;
; OUTPUT:
;    RESULT:  A float scalar in the range [0,1] specifying the degradation 
;        factor by which to multiply the confidence metric in ipccar6_conf.pro, 
;        according to the climate variable.
;
; USES:
;    -
;
; PROCEDURE:
;    This function contains a table matching climate variables to degradation 
;    factors.  See Stone and Hansen (2016) for more details.
;
; EXAMPLE:
;    See ipccar6dna_conf.pro.
;
; MODIFICATION HISTORY:
;    Written by:  Daithi A. Stone (dastone@runbox.com), 2014-12-23 (As 
;        part of hanseng_conf_assess.pro)
;    Modified:  DAS, 2020-07-30 (Adapted from hanseng_conf_assess.pro)
;-

;***********************************************************************

FUNCTION IPCCAR6DNA_CONF_PHYSICS, $
    VAR_LABEL

;***********************************************************************
; Match the variable with the degradation factor

; If this is precipitation
if var_label eq 'pr' then begin
  degrade_factor = 0.8
; If this is near-surface temperature or sea surface temperature
endif else if max( var_label eq [ 'tas', 'tos' ] ) then begin
  degrade_factor = 1.0
; Otherwise not yet supported
endif else begin
  stop
endelse

;***********************************************************************
; The end

return, degrade_factor
END
